/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.rendimiento.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresConcRetencion
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String[]>> tiposRendimiento = new LinkedHashMap<String, ElementoNombreValor<String[]>>();
    private int anio;
    private int mes;
    private Periodo periodo;
    private String esMicroEmpresa;
    private Date fechaSelecContable;

    public int getAnio() {
        return this.anio;
    }

    public void setAnio(int anio) {
        this.anio = anio;
    }

    public int getMes() {
        return this.mes;
    }

    public void setMes(int mes) {
        this.mes = mes;
    }

    public String getEsMicroEmpresa() {
        return this.esMicroEmpresa;
    }

    public void setEsMicroEmpresa(String esMicroEmpresa) {
        this.esMicroEmpresa = esMicroEmpresa;
    }

    public Date getFechaSelecContable() {
        return this.fechaSelecContable;
    }

    public void setFechaSelecContable(Date fechaSelecContable) {
        this.fechaSelecContable = fechaSelecContable;
    }

    public ModeloValoresConcRetencion(int anio, int mes, Periodo periodo, String esMicroEmpresa, Date fechaSelecContable) {
        this.anio = anio;
        this.mes = mes;
        this.periodo = periodo;
        this.esMicroEmpresa = esMicroEmpresa;
        this.fechaSelecContable = fechaSelecContable;
    }

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposRendimiento();
            this.inicializado = true;
        }
    }

    private void cargarTiposRendimiento() {
        this.tiposRendimiento.clear();
        Map datos = UtilCatalogosATS.crearInstancia().obtenerRentenciones(this.anio, this.mes, this.esMicroEmpresa, this.fechaSelecContable);
        for (Map.Entry retencion : datos.entrySet()) {
            if (((String)retencion.getKey()).startsWith("323")) {
                this.tiposRendimiento.put((String)retencion.getKey(), (ElementoNombreValor<String[]>)new ElementoNombreValor(String.valueOf((String)retencion.getKey()) + "-" + ((String[])retencion.getValue())[0], (Object)new String[]{(String)retencion.getKey(), ((String[])retencion.getValue())[1]}));
            }
            if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015() && !this.periodo.isPeriodoDesdeEnero2018() && (((String)retencion.getKey()).equals("324A") || ((String)retencion.getKey()).equals("324B") || ((String)retencion.getKey()).equals("505F") || ((String)retencion.getKey()).equals("505"))) {
                this.tiposRendimiento.put((String)retencion.getKey(), (ElementoNombreValor<String[]>)new ElementoNombreValor(String.valueOf((String)retencion.getKey()) + "-" + ((String[])retencion.getValue())[0], (Object)new String[]{(String)retencion.getKey(), ((String[])retencion.getValue())[1]}));
            }
            if (!this.periodo.isPeriodoDesdeEnero2018() || !((String)retencion.getKey()).equals("324A") && !((String)retencion.getKey()).equals("324B") && !((String)retencion.getKey()).equals("324C") && !((String)retencion.getKey()).equals("505A") && !((String)retencion.getKey()).equals("505B") && !((String)retencion.getKey()).equals("505C") && !((String)retencion.getKey()).equals("505D") && !((String)retencion.getKey()).equals("505E") && !((String)retencion.getKey()).equals("505F") && !((String)retencion.getKey()).equals("505")) continue;
            this.tiposRendimiento.put((String)retencion.getKey(), (ElementoNombreValor<String[]>)new ElementoNombreValor(String.valueOf((String)retencion.getKey()) + "-" + ((String[])retencion.getValue())[0], (Object)new String[]{(String)retencion.getKey(), ((String[])retencion.getValue())[1]}));
        }
    }

    public List<ElementoNombreValor<String[]>> getTiposRendimiento() {
        return new ArrayList<ElementoNombreValor<String[]>>(this.tiposRendimiento.values());
    }

    public ElementoNombreValor<String[]> obtenerTipoIdentificacion(String tipoRendimiento) {
        return StringUtil.isNullOrEmpty((String)tipoRendimiento) ? null : this.tiposRendimiento.get(tipoRendimiento);
    }
}

